@extends('layouts.theme')
@section('main-wrapper')
  <!-- main wrapper -->
  <section id="main-wrapper" class="main-wrapper home-page user-account-section">
    <div class="container-fluid">
      <h4 class="heading">{{__('Invoice Details')}}</h4>
      <ul class="bradcump">
        <li><a href="{{url('account')}}">{{__('Dashboard')}}</a></li>
        <li>/</li>
        <li>{{__('Invoice Details')}}</li>
      </ul>
      <div class="panel-setting-main-block billing-history-main-block">
        <!-- Stripe Billing History -->
        @if(isset($invoices) && $invoices != null)
          <div class="container">
            <h4 class="plan-dtl-heading">{{__('Stripe Billing History')}}</h4>
            <div class="billing-history-block table-responsive">
              <table class="table">
                <thead>
                  <tr>
                    <th>{{__('Date')}}</th>
                    <th>{{__('Package')}}</th>
                    <th>{{__('Service Period')}}</th>
                    <th>{{__('Payment Method')}}</th>
                    <th>{{__('Total')}}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($invoices as $invoice)
                    @php
                      $from = Carbon\Carbon::parse($invoice->subscription_from);
                      $from = $from->toDateString();
                      $to = Carbon\Carbon::parse($invoice->subscription_to);
                      $to = $to->toDateString();
                      $created = Carbon\Carbon::parse($invoice->created);
                      $created = $created->toDateString();
                      $plan = App\Package::where('plan_id', $invoice->lines->data[0]->plan->id)->first();
                    @endphp
                    <tr>
                      <td>{{$created}}</td>
                      <td>{{$plan->name}}</td>
                      <td>{{$from}} to {{$to}}</td>
                      <td>Stripe</td>
                      <td><i class="{{$currency_symbol}}"></i> {{$invoice->lines->data[0]->plan->amount/100}}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        @endif

        <!-- PayPal Billing History -->
        @if (isset($paypal_subscriptions) && $paypal_subscriptions != null && count($paypal_subscriptions) > 0)
          <div class="container">
            <h4 class="plan-dtl-heading">{{__('PayPal Billing History')}}</h4>
            <div class="billing-history-block table-responsive">
              <table class="table">
                <thead>
                  <tr>
                    <th>{{__('Date')}}</th>
                    <th>{{__('Package')}}</th>
                    <th>{{__('Service Period')}}</th>
                    <th>{{__('Payment Method')}}</th>
                    <th>{{__('Total')}}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($paypal_subscriptions as $item)
                    @php
                      $from = Carbon\Carbon::parse($item->subscription_from);
                      $from = $from->toDateString();
                      $to = Carbon\Carbon::parse($item->subscription_to);
                      $to = $to->toDateString();
                    @endphp
                    <tr>
                      <td>{{$item->created_at->toDateString()}}</td>
                      <td>{{$item->plan ? $item->plan->name : 'N/A'}}</td>
                      <td>{{$from}} to {{$to}}</td>
                      <td>{{ucfirst($item->method)}}</td>
                      <td><i class="{{$currency_symbol}}"></i> {{$item->price}}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        @endif

        <!-- PPV Purchases History -->
        @if (isset($ppv_purchases) && $ppv_purchases != null && count($ppv_purchases) > 0)
          <div class="container">
            <h4 class="plan-dtl-heading">{{__('PPV Purchase History')}}</h4>
            <div class="billing-history-block table-responsive">
              <table class="table">
                <thead>
                  <tr>
                    <th>{{__('Date')}}</th>
                    <th>{{__('Content Type')}}</th>
                    <th>{{__('Title')}}</th>
                    <th>{{__('Payment Method')}}</th>
                    <th>{{__('Total')}}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($ppv_purchases as $purchase)
                    @php
                      // Determine content type and title
                      $contentType = ucfirst($purchase->type);
                      $title = 'N/A';
                      if ($purchase->type == 'movie' && $purchase->movie_id) {
                        $movie = App\Movie::find($purchase->movie_id);
                        $title = $movie ? $movie->title : 'N/A';
                      } elseif ($purchase->type == 'series' && $purchase->tv_series_id) {
                        $series = App\Season::find($purchase->tv_series_id);
                        $title = $series ? $series->title : 'N/A';
                      }
                      $created = Carbon\Carbon::parse($purchase->created_at)->toDateString();
                    @endphp
                    <tr>
                      <td>{{$created}}</td>
                      <td>{{$contentType}}</td>
                      <td>{{$title}}</td>
                      <td>{{ucfirst($purchase->payment_type)}}</td>
                      <td><i class="{{$currency_symbol}}"></i> {{$purchase->offer_price ?? $purchase->price}}</td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        @endif
      </div>
    </div>
  </section>
  <!-- end main wrapper -->
@endsection

